/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.tokenring;

import ibm.nways.jdm.I18NMsgFormat;
import ibm.nways.jdm.I18NString;
import ibm.nways.jdm.JdmServerImpl;
import ibm.nways.jdm.StatusType;
import ibm.nways.jdm.modelgen.StatusMapper;
import ibm.nways.jdm.modelgen.StatusModelInfo;
import ibm.nways.jdm.modelgen.TableStatusNamer;
import ibm.nways.tokenring.TokenRingRingStatus;
import ibm.nways.tokenring.TokenRingStatusExplanation;
import ibm.nways.tokenring.model.TokenRingInterfacesModel;
import java.util.Locale;

public class ActionTokenRing
implements StatusMapper,
TableStatusNamer {
    private static final String bundleName = "ibm.nways.tokenring.Resources";
    private static final String euiBundleName = "ibm.nways.tokenring.eui.EnumeratedResources";
    private boolean loggingOn = false;

    public ActionTokenRing() {
        String string = JdmServerImpl.getProperty("startLogging");
        if (string != null && string.equals("yes")) {
            this.loggingOn = true;
        }
    }

    public void calculateStatus(StatusModelInfo statusModelInfo, StatusModelInfo statusModelInfo2) {
        try {
            if (this.loggingOn) {
                System.out.println("ActionTokenRing");
            }
            Object[] objectArray = statusModelInfo.getIndexes();
            if (this.loggingOn) {
                System.out.println("Interface = " + objectArray[0]);
            }
            StatusAndExplain statusAndExplain = this.evaluateState((Integer)statusModelInfo.get("Panel.Dot5RingStatus"), (Integer)statusModelInfo.get("Panel.Dot5RingState"), (Integer)statusModelInfo.get("Panel.Dot5RingOpenStatus"), objectArray);
            statusModelInfo.setStatusType(statusAndExplain.statType, statusAndExplain.explain, true);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public I18NString nameThatObject(StatusModelInfo statusModelInfo) {
        Object[] objectArray = statusModelInfo.getIndexes();
        I18NMsgFormat i18NMsgFormat = new I18NMsgFormat(bundleName, "STATUS_NAME", objectArray);
        return i18NMsgFormat;
    }

    public I18NString nameThatTableObject(StatusModelInfo statusModelInfo) {
        I18NString i18NString = new I18NString(bundleName, "STATUS_TABLE_NAME");
        return i18NString;
    }

    private StatusAndExplain evaluateState(int n, int n2, int n3, Object[] objectArray) {
        StatusAndExplain statusAndExplain = new StatusAndExplain();
        Object[] objectArray2 = new Object[13];
        int n4 = 1;
        if (n == 0) {
            statusAndExplain.statType = StatusType.NORMAL;
            objectArray2[n4++] = new I18NString(bundleName, "OKAY");
        } else {
            TokenRingRingStatus tokenRingRingStatus = new TokenRingRingStatus(n);
            if (tokenRingRingStatus.isReserved()) {
                statusAndExplain.statType = StatusType.UNKNOWN;
                objectArray2[n4++] = tokenRingRingStatus.reserved();
            }
            if (tokenRingRingStatus.isSingleStation()) {
                statusAndExplain.statType = StatusType.NORMAL;
                objectArray2[n4++] = tokenRingRingStatus.singleStation();
            }
            if (tokenRingRingStatus.isRemoveReceived()) {
                statusAndExplain.statType = StatusType.NORMAL;
                objectArray2[n4++] = tokenRingRingStatus.removeReceived();
            }
            if (tokenRingRingStatus.isAutoRemove()) {
                statusAndExplain.statType = StatusType.MARGINAL;
                objectArray2[n4++] = tokenRingRingStatus.autoRemove();
            }
            if (tokenRingRingStatus.isRingRecovery()) {
                statusAndExplain.statType = StatusType.MARGINAL;
                objectArray2[n4++] = tokenRingRingStatus.ringRecovery();
            }
            if (tokenRingRingStatus.isSoftError()) {
                statusAndExplain.statType = StatusType.MARGINAL;
                objectArray2[n4++] = tokenRingRingStatus.softError();
            }
            if (tokenRingRingStatus.isHardError()) {
                statusAndExplain.statType = StatusType.MARGINAL;
                objectArray2[n4++] = tokenRingRingStatus.hardError();
            }
            if (tokenRingRingStatus.isWireFault()) {
                statusAndExplain.statType = StatusType.CRITICAL;
                objectArray2[n4++] = tokenRingRingStatus.wireFault();
            }
            if (tokenRingRingStatus.isBeacon()) {
                statusAndExplain.statType = StatusType.CRITICAL;
                objectArray2[n4++] = tokenRingRingStatus.beacon();
            }
            if (tokenRingRingStatus.isSignalLoss()) {
                statusAndExplain.statType = StatusType.CRITICAL;
                objectArray2[n4++] = tokenRingRingStatus.signalLoss();
            }
            if (tokenRingRingStatus.isNotOpen()) {
                objectArray2[n4++] = tokenRingRingStatus.notOpen();
                switch (n2) {
                    case 1: {
                        statusAndExplain.statType = StatusType.NORMAL;
                        objectArray2[n4++] = new I18NString(euiBundleName, "ibm.nways.tokenring.model.TokenRingInterfacesModel.Panel.Dot5RingState.opened");
                        break;
                    }
                    case 2: {
                        try {
                            if (n3 > 1 && n3 < 11) {
                                statusAndExplain.statType = StatusType.CRITICAL;
                            }
                            if (n3 == 11) {
                                statusAndExplain.statType = StatusType.NORMAL;
                            }
                            if (n3 == 1) {
                                statusAndExplain.statType = StatusType.UNKNOWN;
                            }
                            objectArray2[n4 - 1] = new I18NString(bundleName, "USE_OPEN_STATUS");
                            objectArray2[n4++] = new I18NString(euiBundleName, TokenRingInterfacesModel.Panel.Dot5RingOpenStatusEnum.numericToSymbolic(n3));
                        }
                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                            statusAndExplain.statType = StatusType.UNKNOWN;
                            objectArray2[n4++] = new I18NString(euiBundleName, "ibm.nways.tokenring.model.TokenRingInterfacesModel.Panel.Dot5RingState.closed");
                        }
                        break;
                    }
                    case 3: {
                        statusAndExplain.statType = StatusType.NORMAL;
                        objectArray2[n4++] = new I18NString(euiBundleName, "ibm.nways.tokenring.model.TokenRingInterfacesModel.Panel.Dot5RingState.opening");
                        break;
                    }
                    case 4: {
                        statusAndExplain.statType = StatusType.UNKNOWN;
                        objectArray2[n4++] = new I18NString(euiBundleName, "ibm.nways.tokenring.model.TokenRingInterfacesModel.Panel.Dot5RingState.closing");
                        break;
                    }
                    case 5: {
                        statusAndExplain.statType = StatusType.CRITICAL;
                        objectArray2[n4++] = new I18NString(euiBundleName, "ibm.nways.tokenring.model.TokenRingInterfacesModel.Panel.Dot5RingState.openFailure");
                        break;
                    }
                    case 6: {
                        statusAndExplain.statType = StatusType.CRITICAL;
                        objectArray2[n4++] = new I18NString(euiBundleName, "ibm.nways.tokenring.model.TokenRingInterfacesModel.Panel.Dot5RingState.ringFailure");
                        break;
                    }
                    default: {
                        statusAndExplain.statType = StatusType.UNKNOWN;
                        objectArray2[n4++] = new Integer(n);
                        break;
                    }
                }
            }
        }
        if (statusAndExplain.statType == null) {
            statusAndExplain.statType = StatusType.UNKNOWN;
            objectArray2[n4++] = new Integer(n);
        }
        objectArray2[0] = new Integer(n4);
        statusAndExplain.explain = new TokenRingStatusExplanation(bundleName, "BASE_STATUS", objectArray, objectArray2);
        if (this.loggingOn) {
            System.out.println("ret.statType = " + statusAndExplain.statType);
            int n5 = 0;
            while (n5 < n4) {
                if (objectArray2[n5] instanceof I18NString) {
                    System.out.println("moreArgs[" + n5 + "]  bundleName = " + ((I18NString)objectArray2[n5]).getBundleName());
                    System.out.println("moreArgs[" + n5 + "]  key  = " + ((I18NString)objectArray2[n5]).getKey());
                } else {
                    System.out.println("moreArgs[" + n5 + "] = " + objectArray2[n5].toString());
                }
                ++n5;
            }
            System.out.println(statusAndExplain.explain.getTranslation(Locale.getDefault()));
        }
        return statusAndExplain;
    }

    private class StatusAndExplain {
        StatusType statType;
        TokenRingStatusExplanation explain;

        StatusAndExplain() {
            ActionTokenRing.this = ActionTokenRing.this;
        }
    }
}

